<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Developer</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Bootstrap CSS -->
    <link href="{{ asset('front/css/bootstrap.min.css') }}" rel="stylesheet">

    {{-- css link --}}
    <link rel="stylesheet" href="{{ asset('assets/css/vcard17.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick-theme.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/custom.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom-vcard.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/third-party.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/plugins.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/lightbox.css') }}">
</head>

<body>
    <div class="container p-0">
        <div class="main-content mx-auto w-100 overflow-hidden border">
            <div class="banner-section position-relative">
                <div class="banner-img">
                    <img src="{{ asset('assets/img/vcard17/banner.png') }}" class="w-100 h-100 object-fit-cover" loading="lazy"/>
                    <div class="d-flex justify-content-end position-absolute top-0 end-0 me-3">
                        <div class="language pt-3 me-2">
                            <ul class="text-decoration-none">
                                <li class="dropdown1 dropdown lang-list">
                                    <a class="dropdown-toggle lang-head text-decoration-none" data-toggle="dropdown"
                                        role="button" aria-haspopup="true" aria-expanded="false">
                                        <i class="fa-solid fa-language me-2"></i>Language</a>
                                    <ul class="dropdown-menu start-0 lang-hover-list top-100 mt-0">
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/english.png') }}" width="25px"
                                                height="20px" class="me-3" loading="lazy"><a href="#">English</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/spain.png') }}" width="25px"
                                                height="20px" class="me-3" loading="lazy"><a href="#">Spanish</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/france.png') }}" width="25px"
                                                height="20px" class="me-3" loading="lazy"><a href="#">Franch</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/arabic.svg') }}" width="25px"
                                                height="20px" class="me-3" loading="lazy"><a href="#">Arabic</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/german.png') }}" width="25px"
                                                height="20px" class="me-3" loading="lazy"><a href="#">German</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/russian.jpeg') }}" width="25px"
                                                height="20px" class="me-3" loading="lazy"><a href="#">russian</a>
                                        </li>
                                        <li>
                                            <img src="{{ asset('assets/img/vcard1/turkish.png') }}" width="25px"
                                                height="20px" class="me-3" loading="lazy"><a href="#">Turkish</a>
                                        </li>

                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="overlay"></div>
                </div>
            </div>
            <div class="profile-section px-30">
                <div class="profile-bg">
                    <img src="{{ asset('assets/img/vcard17/profile-bg.png') }}" loading="lazy"/>
                </div>
                <div class="profile-bg-vector">
                    <img src="{{ asset('assets/img/vcard17/profile-bg-vector.png') }}" loading="lazy"/>
                </div>
                <div class="tag-img">
                    <img src="{{ asset('assets/img/vcard17/tag.png') }}" loading="lazy"/>
                </div>
                <div class="card align-items-center mb-3 pb-3">
                    <div class="card-img d-flex justify-content-center align-items-center">
                        <img src="{{ asset('assets/img/vcard17/profile-img.png') }}"
                            class="img-fluid h-100 object-fit-cover" loading="lazy"/>
                    </div>
                    <div class="card-body pt-30 pb-0 px-0 text-center">
                        <div class="profile-name">
                            <h4 class="text-primary mb-0 fw-bold">Mary Arden</h4>
                            <p class="fs-18 text-gray-300 mb-0 fw-5">Developer</p>
                        </div>
                    </div>
                </div>
                <div class="social-media d-flex justify-content-center mb-40">
                    <div class="social-media-icon d-flex bg-gray-100 justify-content-center">
                        <a href="" class="social-icon d-flex justify-content-center align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="13" height="25"
                                viewBox="0 0 13 25" fill="none">
                                <path
                                    d="M3.73824 14.1111C3.18372 14.1111 2.67459 14.1111 2.16547 14.1111C1.73123 14.1111 1.297 14.1193 0.863524 14.1079C0.409622 14.0964 0.261348 13.9495 0.257565 13.4638C0.24773 12.1912 0.246974 10.9179 0.258322 9.64528C0.262861 9.16368 0.421726 9.01103 0.869577 9.00777C1.7093 9.00205 2.54901 9.00613 3.38949 9.00613C3.49237 9.00613 3.59526 9.00613 3.73824 9.00613C3.73824 8.86818 3.73673 8.74982 3.73824 8.63228C3.75791 7.47235 3.71706 6.30752 3.80935 5.15412C4.04311 2.21633 6.12123 0.1185 8.85372 0.0229951C9.96578 -0.0161863 11.0809 0.00585325 12.1937 0.00911836C12.5856 0.00993464 12.7444 0.182986 12.7459 0.60745C12.7512 1.7984 12.7512 2.99016 12.7467 4.18111C12.7452 4.63741 12.5969 4.80312 12.1619 4.81373C11.3978 4.83332 10.6338 4.83332 9.86895 4.84638C9.01183 4.86026 8.65173 5.22187 8.63357 6.13528C8.61542 7.05849 8.62979 7.98334 8.62979 8.94246C8.75915 8.94246 8.85977 8.94246 8.96038 8.94246C9.93249 8.94246 10.9046 8.94083 11.8767 8.94328C12.4895 8.9441 12.6332 9.09756 12.634 9.74731C12.6347 10.9587 12.6362 12.1708 12.6332 13.3822C12.6317 13.9242 12.4993 14.0703 11.994 14.0728C10.8902 14.0777 9.78649 14.0744 8.63055 14.0744C8.63055 14.2164 8.63055 14.343 8.63055 14.4687C8.63055 17.6554 8.63055 20.843 8.63055 24.0297C8.63055 24.908 8.54431 24.9995 7.71669 24.9995C6.63111 24.9995 5.54628 25.0011 4.4607 24.9986C3.8797 24.9978 3.73824 24.8468 3.73824 24.2264C3.73748 20.9883 3.73748 17.7501 3.73748 14.5127C3.73824 14.3927 3.73824 14.2728 3.73824 14.1111Z"
                                    fill="#1E1E1E" />
                            </svg>
                        </a>
                        <a href="" class="social-icon d-flex justify-content-center align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"
                                viewBox="0 0 25 25" fill="none">
                                <path
                                    d="M25 11.2256C25 11.7143 25 12.2024 25 12.6912C24.9608 13.0129 24.9289 13.3352 24.8818 13.6557C24.5001 16.2479 23.401 18.4908 21.5606 20.3588C19.5879 22.3613 17.1968 23.5418 14.4032 23.8654C11.9606 24.1486 9.63499 23.7204 7.44909 22.5821C7.29838 22.5039 7.17034 22.4733 6.99451 22.5363C5.70062 22.9999 4.40059 23.4458 3.10363 23.9015C2.06827 24.2648 1.03475 24.6336 0 25C0.0214424 24.8979 0.0312446 24.792 0.0655525 24.6942C0.831352 22.5008 1.59593 20.3062 2.37398 18.1171C2.46526 17.8608 2.45852 17.662 2.33109 17.4137C1.15666 15.1286 0.770088 12.7022 1.14686 10.1693C1.52547 7.62363 2.62516 5.4119 4.44715 3.58796C7.14951 0.883244 10.4339 -0.285619 14.2347 0.0587402C16.545 0.267925 18.6224 1.12056 20.4358 2.57323C22.7976 4.46446 24.2746 6.89393 24.8101 9.87878C24.8897 10.3247 24.9375 10.7767 25 11.2256ZM10.2899 9.86716C10.3052 9.84025 10.3077 9.83169 10.3132 9.82618C10.6287 9.50812 10.946 9.19251 11.2591 8.87262C11.6267 8.49645 11.6267 8.09215 11.2554 7.71721C10.7224 7.17957 10.187 6.64377 9.64785 6.11163C9.26802 5.73669 8.86796 5.73669 8.48935 6.10918C8.09481 6.49758 7.71498 6.90127 7.31063 7.27927C6.85299 7.70743 6.71698 8.23161 6.77886 8.8298C6.8824 9.82435 7.29287 10.7082 7.80013 11.5468C9.11915 13.7267 10.8688 15.4986 12.9929 16.9005C13.8518 17.4675 14.764 17.9324 15.7871 18.1391C16.5737 18.2981 17.2673 18.185 17.826 17.5391C18.1446 17.1709 18.514 16.8461 18.8583 16.4993C19.2528 16.1011 19.2522 15.7072 18.8546 15.3066C18.3498 14.7983 17.8413 14.2931 17.334 13.7872C16.8684 13.323 16.5008 13.3218 16.0377 13.7836C15.7338 14.0869 15.4312 14.3915 15.131 14.6925C12.9506 13.6251 11.3485 12.0251 10.2899 9.86716Z"
                                    fill="#1E1E1E" />
                            </svg>
                        </a>
                        <a href="" class="social-icon d-flex justify-content-center align-items-center">
                            <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M24.983 15.1366C24.9749 13.9763 24.8592 12.8226 24.5218 11.7014C24.0997 10.2974 23.3346 9.1681 21.9698 8.52396C20.9154 8.02659 19.7909 7.88716 18.642 7.9214C16.6309 7.98174 15.0037 8.75797 13.9159 10.5126C13.9037 10.5322 13.8711 10.5395 13.8026 10.5787C13.8026 9.80816 13.8026 9.07188 13.8026 8.33479C12.1298 8.33479 10.4977 8.33479 8.86963 8.33479C8.86963 13.9037 8.86963 19.4507 8.86963 25C10.593 25 12.2887 25 14.0284 25C14.0284 24.8475 14.0284 24.7269 14.0284 24.6054C14.0284 22.0011 14.021 19.396 14.0341 16.7918C14.0365 16.2137 14.074 15.6315 14.1563 15.0599C14.3812 13.4928 15.1781 12.6456 16.6252 12.4744C18.215 12.2869 19.3248 12.8666 19.6393 14.5731C19.751 15.1798 19.7998 15.8052 19.8039 16.4224C19.8218 19.149 19.8137 21.8755 19.8145 24.6021C19.8145 24.7195 19.8145 24.8361 19.8145 24.9478C21.5664 24.9478 23.2694 24.9478 24.9879 24.9478C24.9928 24.8793 25.0001 24.8304 25.0001 24.7807C24.9961 21.5665 25.0042 18.3515 24.983 15.1366Z"
                                    fill="#1E1E1E" />
                                <path
                                    d="M0.429443 24.9886C2.15608 24.9886 3.86642 24.9886 5.58247 24.9886C5.58247 19.427 5.58247 13.8882 5.58247 8.3307C3.86235 8.3307 2.15934 8.3307 0.429443 8.3307C0.429443 13.8988 0.429443 19.4384 0.429443 24.9886Z"
                                    fill="#1E1E1E" />
                                <path
                                    d="M2.98067 0.000119092C1.34204 0.0147956 -0.000814466 1.3683 3.70634e-07 3.00392C0.000815207 4.66726 1.37381 6.0436 3.02223 6.03381C4.66168 6.02403 6.00616 4.65014 5.99638 2.99251C5.98742 1.32916 4.63316 -0.0145575 2.98067 0.000119092Z"
                                    fill="#1E1E1E" />
                            </svg>
                        </a>

                        <a href="" class="social-icon d-flex justify-content-center align-items-center">
                            <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M24.9972 5.76124C24.9972 10.253 24.9972 14.744 24.9972 19.2357C24.8986 19.7027 24.8405 20.1834 24.6945 20.6351C23.8431 23.262 21.4807 24.9855 18.7086 24.9931C14.5676 25.0046 10.4267 24.9993 6.28576 24.9947C4.95589 24.9931 3.72997 24.6255 2.65308 23.8383C0.873808 22.5375 0.000985528 20.7681 0.000985528 18.5662C0.000221236 14.5391 -0.00207164 10.5121 0.00480699 6.48502C0.00557128 6.07231 0.0246786 5.65194 0.098815 5.24687C0.518412 2.93718 1.8307 1.32605 3.99824 0.444054C4.55388 0.217823 5.17219 0.143687 5.76146 0C10.2532 0 14.7442 0 19.2359 0C19.411 0.031336 19.5867 0.0603791 19.761 0.0932437C22.0554 0.526598 23.662 1.8259 24.5455 3.97738C24.7771 4.53913 24.8512 5.16509 24.9972 5.76124ZM22.8992 12.4985C22.9022 12.4985 22.9053 12.4985 22.9084 12.4985C22.9084 10.4647 22.9045 8.43091 22.9107 6.39637C22.9122 5.74442 22.8251 5.11159 22.5339 4.52538C21.7451 2.93641 20.4588 2.09645 18.6803 2.09034C14.5554 2.07582 10.4305 2.08499 6.30563 2.08805C6.06259 2.08805 5.81802 2.11098 5.57803 2.14537C3.68488 2.41211 2.11731 4.12412 2.10508 6.04097C2.0768 10.2958 2.09362 14.5506 2.09133 18.8054C2.09133 19.3832 2.20444 19.9412 2.45895 20.4578C3.2584 22.0774 4.56916 22.9043 6.37824 22.9066C10.4542 22.9127 14.5302 22.9097 18.6062 22.9059C18.8813 22.9059 19.1587 22.8845 19.4316 22.847C21.2881 22.5925 22.8671 20.8614 22.8923 18.9896C22.9221 16.8267 22.8992 14.663 22.8992 12.4985Z"
                                    fill="#1E1E1E" />
                                <path
                                    d="M18.747 12.529C18.7141 15.9898 15.8793 18.7909 12.4553 18.7458C8.99841 18.7007 6.21791 15.8873 6.25078 12.4664C6.28364 9.00413 9.11611 6.20605 12.5417 6.24962C15.9993 6.29471 18.7798 9.10807 18.747 12.529ZM12.5027 8.33766C10.2037 8.33384 8.348 10.1834 8.33882 12.4885C8.32889 14.7845 10.1769 16.644 12.4836 16.6593C14.7864 16.6738 16.662 14.8043 16.6597 12.4962C16.6574 10.1941 14.8047 8.34149 12.5027 8.33766Z"
                                    fill="#1E1E1E" />
                                <path
                                    d="M19.2812 7.28217C18.4114 7.28828 17.7144 6.5966 17.7144 5.7276C17.7151 4.87235 18.3992 4.18067 19.2575 4.16691C20.1051 4.15315 20.8327 4.87465 20.8319 5.72836C20.8319 6.57902 20.1356 7.27605 19.2812 7.28217Z"
                                    fill="#1E1E1E" />
                            </svg>
                        </a>

                        <a href="" class="social-icon d-flex justify-content-center align-items-center">
                            <svg width="25" height="22" viewBox="0 0 25 22" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M7.38939 16.6214C5.04282 16.3168 3.48596 15.2112 2.606 13C3.36186 13 4.02748 13 4.68181 13C2.30139 12.0636 0.958884 10.4278 0.78966 7.83304C1.51168 8.03611 2.1773 8.22789 2.84291 8.4084C2.87675 8.36327 2.9106 8.31815 2.94444 8.27302C1.95166 7.47203 1.24092 6.47925 0.992729 5.21571C0.744534 3.95217 0.857349 2.73376 1.54553 1.4815C4.38849 4.71932 7.86321 6.60335 12.1389 6.8741C12.1389 6.40028 12.1277 5.99414 12.1389 5.588C12.2066 3.43322 13.2671 1.86508 15.1962 0.996396C17.0803 0.150277 18.9305 0.375909 20.555 1.70714C21.0063 2.07943 21.4124 2.1584 21.9201 1.95533C22.6985 1.65073 23.4769 1.34613 24.3231 1.03024C23.962 2.1584 23.2175 2.92555 22.439 3.76039C23.2513 3.54604 24.0636 3.3204 24.8758 3.10605C24.9097 3.1399 24.9548 3.17374 24.9887 3.20759C24.3456 3.8732 23.7364 4.59522 23.0369 5.19315C22.6534 5.52031 22.5067 5.84748 22.4954 6.33259C22.4277 9.72834 21.4124 12.8082 19.314 15.4932C16.4936 19.1146 12.7481 20.9422 8.13397 21.0325C5.49408 21.0889 3.02341 20.5361 0.699407 19.2838C0.473776 19.1598 0.248144 19.0244 0.0112305 18.8326C2.68497 18.9567 5.12179 18.3249 7.38939 16.6214Z"
                                    fill="#1E1E1E" />
                            </svg>
                        </a>
                    </div>
                </div>
                <p class="text-gray-300 mb-0 text-center profile-desc">
                    Lorem Ipsum is simply dummy text of the printing and typesetting
                    industry. Lorem Ipsum has been the industry's standard dummy text
                    ever since the 1500s, when an unknown printer took a galley of type
                    and scrambled it to make a type specimen book.
                </p>
            </div>
            <div class="contact-section">
                <div class="px-30">
                    <div class="row">
                        <div class="col-sm-6 mb-sm-5 mb-40 px-3">
                            <div class="contact-box mb-sm-2">
                                <div class="contact-icon d-flex justify-content-center align-items-center bg-pink">
                                    <svg width="27" height="20" viewBox="0 0 27 20" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_224_413)">
                                            <path
                                                d="M13.5257 -0.000499526C16.9638 -0.000499526 20.395 -0.00716841 23.8331 0.00616936C24.2828 0.00616936 24.7394 0.0528516 25.1752 0.146216C25.9569 0.319607 26.4965 0.799767 26.8354 1.49333C27.1329 2.1002 27.0361 2.43364 26.455 2.7871C25.7009 3.24725 24.94 3.70073 24.1859 4.16089C20.8931 6.18156 17.6002 8.1889 14.3212 10.2229C13.7263 10.5964 13.2559 10.583 12.661 10.2162C8.66942 7.74208 4.65712 5.30127 0.651744 2.84712C0.568731 2.79376 0.4788 2.74708 0.402705 2.69373C0.00839283 2.43364 -0.0677025 2.22691 0.0706526 1.79343C0.409623 0.726409 1.25359 0.106203 2.49187 0.0395138C2.98994 0.0128383 3.48802 0.0128383 3.97918 0.00616936C7.16135 0.00616936 10.3435 0.00616936 13.5257 -0.000499526C13.5257 0.00616936 13.5257 -0.000499526 13.5257 -0.000499526Z"
                                                fill="white" />
                                            <path
                                                d="M13.4692 20C9.9757 20 6.48915 20.0067 2.99568 19.9934C2.55987 19.9934 2.11021 19.9467 1.68823 19.8333C0.837345 19.5999 0.311595 19.0197 0.0556381 18.2128C-0.0757992 17.7926 0.000296065 17.5859 0.394608 17.3458C3.61828 15.3918 6.84196 13.4378 10.0656 11.4838C10.4046 11.2771 10.7643 11.2771 11.1033 11.4705C11.7121 11.8173 12.307 12.1774 12.9019 12.5442C13.3931 12.851 13.6006 12.8576 14.0779 12.5575C14.7074 12.1641 15.3439 11.7839 15.9734 11.3905C16.3124 11.1771 16.6167 11.2438 16.928 11.4372C17.9588 12.0774 18.9895 12.7109 20.0272 13.3445C22.144 14.6382 24.2678 15.9187 26.3846 17.2124C27.0349 17.6059 27.1387 17.9327 26.8204 18.5929C26.3846 19.4865 25.596 19.8666 24.6344 19.98C24.3923 20.0067 24.1502 20.0067 23.9081 20.0067C20.4284 20 16.9488 20 13.4692 20Z"
                                                fill="white" />
                                            <path
                                                d="M0.0490723 15.3651C0.0490723 11.7773 0.0490723 8.24942 0.0490723 4.66156C2.96837 6.45549 5.84615 8.21608 8.77236 10.01C5.85307 11.8039 2.97528 13.5712 0.0490723 15.3651Z"
                                                fill="white" />
                                            <path
                                                d="M18.249 10.01C21.1614 8.22275 24.0392 6.45549 26.9585 4.66156C26.9585 8.23608 26.9585 11.7573 26.9585 15.3518C24.0461 13.5712 21.1683 11.8039 18.249 10.01Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_224_413">
                                                <rect width="27" height="20" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gray-300 mb-0 fs-12 fw-6">E-mail address</p>
                                    <a href="mailto:jackie@gmail.com"
                                        class="text-primary fs-14 fw-5">jackie@gmail.com</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 mb-sm-5 mb-40 px-3">
                            <div class="contact-box mb-sm-2">
                                <div class="contact-icon d-flex justify-content-center align-items-center bg-orange">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M4.03739 8.65636C5.68025 11.8074 8.01358 14.1974 11.0969 15.8383C11.2279 15.9096 11.5374 15.8264 11.6683 15.7075C12.3707 15.0416 13.0612 14.3639 13.7279 13.6623C14.0969 13.2699 14.5017 13.2105 15.0136 13.3056C16.2279 13.5196 17.4541 13.7337 18.6802 13.8763C19.6564 13.9952 20.0017 14.3163 20.0017 15.3151C20.0017 16.3853 20.0017 17.4435 20.0017 18.5137C20.0017 19.6671 19.6326 20.0238 18.4541 20C10.0731 19.8573 2.5731 13.912 0.596913 5.75505C0.251675 4.31629 0.144532 2.80618 0.0135796 1.31986C-0.0697538 0.439952 0.418341 0.0118906 1.29929 0.0118906C2.46596 0 3.63263 0 4.79929 0C5.65644 0 6.01358 0.39239 6.12072 1.24851C6.28739 2.50892 6.51358 3.76932 6.75168 5.01784C6.84691 5.55291 6.75168 5.98098 6.35882 6.36147C5.5731 7.12247 4.8112 7.88347 4.03739 8.65636Z"
                                            fill="white" />
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gray-300 mb-0 fs-12 fw-6">Mobile Number</p>
                                    <a href="tel:+1 4078461474" class="text-primary fs-14 fw-5">+1 4078461474</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 mb-sm-0 mb-40 px-3">
                            <div class="contact-box">
                                <div class="contact-icon d-flex justify-content-center align-items-center bg-blue">
                                    <svg width="25" height="22" viewBox="0 0 25 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_224_569)">
                                            <path
                                                d="M0.325524 22C0.220526 21.7982 0.0525292 21.607 0.0210298 21.3945C-0.0314691 21.0121 0.0210298 20.619 3.02244e-05 20.2366C-0.0104696 19.886 0.136527 19.7055 0.49352 19.7161C0.598518 19.7161 0.703516 19.7161 0.808514 19.7161C8.60986 19.7161 16.4007 19.7161 24.202 19.7267C24.4645 19.7267 24.727 19.8329 24.9895 19.886C24.9895 20.5872 24.9895 21.2989 24.9895 22C16.7787 22 8.54686 22 0.325524 22Z"
                                                fill="white" />
                                            <path
                                                d="M12.5263 9.00821C15.3297 9.00821 18.1332 9.00821 20.9471 9.00821C22.5326 9.00821 23.3096 9.80492 23.3201 11.4196C23.3201 11.4408 23.3201 11.4515 23.3201 11.4727C23.5091 12.4075 23.0786 12.9387 22.2596 13.2999C21.4301 13.661 20.6321 13.7354 19.9076 13.1086C19.5506 12.8006 19.2566 12.4288 18.9626 12.057C18.5742 11.5789 18.2067 11.5683 17.8077 12.0357C17.5452 12.3438 17.2827 12.6519 16.9887 12.9174C16.1592 13.6717 15.2457 13.7566 14.3112 13.1511C13.8912 12.8749 13.5133 12.5244 13.1458 12.1738C12.6418 11.6958 12.4213 11.6958 11.9278 12.1951C11.6443 12.4819 11.3503 12.7581 11.0248 12.9918C9.92233 13.7991 8.92484 13.746 7.89586 12.8537C7.73837 12.7156 7.59137 12.5669 7.45487 12.4075C6.75139 11.5896 6.60439 11.5896 5.90091 12.4394C4.94542 13.5867 3.73795 13.8416 2.39398 13.2255C1.86899 12.9812 1.66949 12.6094 1.72199 12.057C1.75349 11.7914 1.78499 11.5258 1.75349 11.2709C1.57499 9.96427 2.61447 8.98696 3.95844 8.99758C6.80389 9.02945 9.65983 9.00821 12.5263 9.00821Z"
                                                fill="white" />
                                            <path
                                                d="M23.1102 18.282C16.0438 18.282 9.00899 18.282 1.94263 18.282C1.94263 17.1666 1.94263 16.0512 1.94263 14.8933C3.69609 15.4882 5.22906 15.1057 6.48904 13.7354C8.58899 15.775 10.521 15.4988 12.5474 13.6716C15.0569 15.8812 16.8628 15.3713 18.5743 13.6398C19.1518 14.2665 19.7818 14.8402 20.6428 15.0632C21.4932 15.2863 22.2912 15.1057 23.1312 14.7446C23.1102 15.9343 23.1102 17.0816 23.1102 18.282Z"
                                                fill="white" />
                                            <path
                                                d="M11.0248 8.00965C11.0248 6.95799 11.0143 5.92757 11.0353 4.88653C11.0458 4.54659 11.2873 4.34476 11.6338 4.34476C12.2113 4.33414 12.7888 4.33414 13.3558 4.34476C13.7548 4.34476 13.9858 4.57846 13.9858 4.97151C14.0068 5.97006 13.9963 6.97923 13.9963 8.00965C12.9988 8.00965 12.0328 8.00965 11.0248 8.00965Z"
                                                fill="white" />
                                            <path
                                                d="M12.5157 0C12.7677 0.467407 13.0617 0.998551 13.3451 1.54032C13.4711 1.78465 13.6391 2.02897 13.7126 2.29454C13.8701 2.8788 13.6181 3.51618 13.1667 3.77113C12.7152 4.02607 12.0222 3.95171 11.6547 3.61178C11.2662 3.23998 11.1402 2.52825 11.4132 2.00773C11.7702 1.30662 12.1587 0.62675 12.5157 0Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_224_569">
                                                <rect width="25" height="22" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gray-300 mb-0 fs-12 fw-6">Date of Birth</p>
                                    <p class="text-primary fs-14 fw-5 mb-0">12th June, 1990</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 px-3">
                            <div class="contact-box">
                                <div class="contact-icon d-flex justify-content-center align-items-center bg-purple">
                                    <svg width="17" height="22" viewBox="0 0 17 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_224_576)">
                                            <path
                                                d="M8.49436 18.0444C8.20972 17.7124 7.93625 17.3974 7.66836 17.0796C6.22286 15.3486 4.85549 13.5581 3.6723 11.6314C3.1393 10.7659 2.67328 9.86637 2.27423 8.92712C1.54032 7.19334 1.66589 5.48793 2.47515 3.83644C3.52161 1.70256 5.23779 0.43131 7.55953 0.0766086C11.1314 -0.468213 14.5247 2.07996 15.108 5.68089C15.2977 6.86134 15.1163 7.96801 14.6615 9.05197C14.1536 10.2608 13.4978 11.3845 12.7834 12.4713C11.5082 14.4065 10.0822 16.2198 8.56412 17.9621C8.54738 17.9819 8.52785 18.0046 8.49436 18.0444ZM11.8514 6.23706C11.8542 4.35856 10.3473 2.82909 8.49715 2.82909C6.64423 2.82909 5.14012 4.35573 5.14012 6.23423C5.14012 8.11272 6.64423 9.6422 8.49436 9.6422C10.3445 9.6422 11.8486 8.1184 11.8514 6.23706Z"
                                                fill="white" />
                                            <path
                                                d="M5.88509 15.7317C5.56138 15.7799 5.24047 15.8253 4.92235 15.8821C3.9624 16.0495 3.02199 16.285 2.13459 16.7078C1.78857 16.8753 1.45928 17.0682 1.1886 17.3491C0.753275 17.8032 0.753275 18.2685 1.19976 18.714C1.57928 19.0943 2.05088 19.3156 2.53922 19.5086C3.48522 19.8775 4.47307 20.0789 5.47488 20.2151C6.8562 20.4052 8.24589 20.4507 9.63837 20.3825C11.1983 20.3059 12.7415 20.1073 14.2288 19.5909C14.6697 19.4376 15.0995 19.256 15.479 18.9723C15.6492 18.8446 15.8138 18.697 15.945 18.5296C16.1989 18.2061 16.2073 17.8457 15.945 17.5307C15.7664 17.3151 15.546 17.1193 15.3115 16.9661C14.6558 16.5376 13.9191 16.2935 13.1656 16.1176C12.5405 15.9729 11.9071 15.8793 11.2764 15.7629C11.2206 15.7516 11.1676 15.7431 11.1118 15.7345C11.215 15.5132 11.2346 15.5075 11.4606 15.5246C12.3926 15.5983 13.3219 15.7005 14.2344 15.9076C14.7311 16.0183 15.2223 16.1517 15.6715 16.3929C15.9534 16.5433 16.2324 16.7192 16.464 16.9348C17.0584 17.491 17.1645 18.2629 16.785 18.9893C16.5812 19.3809 16.2827 19.6902 15.9422 19.9597C15.1999 20.5471 14.3544 20.9359 13.467 21.2338C11.6001 21.8609 9.67744 22.0681 7.71848 21.983C6.21437 21.9149 4.74375 21.668 3.32058 21.1515C2.44435 20.8337 1.60997 20.4365 0.895593 19.8122C0.583052 19.5398 0.31795 19.222 0.150517 18.8332C-0.131328 18.1777 -0.00296259 17.4853 0.490964 16.9774C0.903965 16.5518 1.4258 16.3163 1.96995 16.1318C2.71503 15.8793 3.48522 15.7487 4.26099 15.6522C4.69073 15.5983 5.12048 15.5671 5.55301 15.5217C5.7623 15.5019 5.77905 15.5132 5.88509 15.7317Z"
                                                fill="white" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_224_576">
                                                <rect width="17" height="22" fill="white" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="contact-desc">
                                    <p class="text-gray-300 mb-0 fs-12 fw-6">Address</p>
                                    <p class="text-primary fs-14 fw-5 mb-0">New York, USA</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="appointment-section pt-60 pb-60 px-30">
                <div class="appointment-bg">
                    <img src="{{ asset('assets/img/vcard17/appointment-bg.png') }}" loading="lazy"/>
                </div>
                <div class="html-img">
                    <img src="{{ asset('assets/img/vcard17/html.png') }}" loading="lazy"/>
                </div>
                <div class="php-tag">
                    <img src="{{ asset('assets/img/vcard17/php.png') }}" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="text-primary fw-bold">Make an Appointment</h2>
                </div>

                <div class="appointment">
                    <div class="mb-20">
                        <label for="date" class="appoint-date text-primary fs-20 fw-5 mb-2">Date:</label>
                        <div class="position-relative">
                            <input type="text" class="form-control bg-white appointment-input" />
                            <span class="calendar-icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.75 9.375V10.625C5.75 10.6943 5.69433 10.75 5.625 10.75H4.375C4.30567 10.75 4.25 10.6943 4.25 10.625V9.375C4.25 9.30567 4.30567 9.25 4.375 9.25H5.625C5.69433 9.25 5.75 9.30567 5.75 9.375ZM4.375 14.25H5.625C5.69433 14.25 5.75 14.3057 5.75 14.375V15.625C5.75 15.6943 5.69433 15.75 5.625 15.75H4.375C4.30567 15.75 4.25 15.6943 4.25 15.625V14.375C4.25 14.3057 4.30567 14.25 4.375 14.25ZM9.375 9.25H10.625C10.6943 9.25 10.75 9.30567 10.75 9.375V10.625C10.75 10.6943 10.6943 10.75 10.625 10.75H9.375C9.30567 10.75 9.25 10.6943 9.25 10.625V9.375C9.25 9.30567 9.30567 9.25 9.375 9.25ZM9.375 14.25H10.625C10.6943 14.25 10.75 14.3057 10.75 14.375V15.625C10.75 15.6943 10.6943 15.75 10.625 15.75H9.375C9.30567 15.75 9.25 15.6943 9.25 15.625V14.375C9.25 14.3057 9.30567 14.25 9.375 14.25ZM14.375 9.25H15.625C15.6943 9.25 15.75 9.30567 15.75 9.375V10.625C15.75 10.6943 15.6943 10.75 15.625 10.75H14.375C14.3057 10.75 14.25 10.6943 14.25 10.625V9.375C14.25 9.30567 14.3057 9.25 14.375 9.25ZM14.375 14.25H15.625C15.6943 14.25 15.75 14.3057 15.75 14.375V15.625C15.75 15.6943 15.6943 15.75 15.625 15.75H14.375C14.3057 15.75 14.25 15.6943 14.25 15.625V14.375C14.25 14.3057 14.3057 14.25 14.375 14.25ZM5.625 3.25H4.375C4.30567 3.25 4.25 3.19433 4.25 3.125V0.625C4.25 0.555674 4.30567 0.5 4.375 0.5H5.625C5.69433 0.5 5.75 0.555674 5.75 0.625V3.125C5.75 3.19433 5.69433 3.25 5.625 3.25ZM19.5 5V17.5C19.5 18.6045 18.6045 19.5 17.5 19.5H2.5C1.39552 19.5 0.5 18.6045 0.5 17.5V5C0.5 3.89552 1.39552 3 2.5 3H2.625V3.125C2.625 4.08946 3.40959 4.875 4.375 4.875H5.625C6.59041 4.875 7.375 4.08946 7.375 3.125V3H12.625V3.125C12.625 4.08962 13.4104 4.875 14.375 4.875H15.625C16.5896 4.875 17.375 4.08962 17.375 3.125V3H17.5C18.6045 3 19.5 3.89552 19.5 5ZM19.25 7.5C19.25 6.5357 18.4661 5.75 17.5 5.75H2.5C1.53459 5.75 0.75 6.53554 0.75 7.5V17.5C0.75 18.466 1.53491 19.25 2.5 19.25H17.5C18.4658 19.25 19.25 18.4658 19.25 17.5V7.5ZM15.625 3.25H14.375C14.3057 3.25 14.25 3.19433 14.25 3.125V0.625C14.25 0.555674 14.3057 0.5 14.375 0.5H15.625C15.6943 0.5 15.75 0.555674 15.75 0.625V3.125C15.75 3.19433 15.6943 3.25 15.625 3.25Z"
                                        fill="#9B9B9B" stroke="#9B9B9B" />
                                </svg>
                            </span>
                        </div>
                    </div>
                    <div class="">
                        <label class="text-primary fs-20 fw-5 mb-2">Hour:</label>

                        <div class="mb-20">
                            <div class="row">
                                <div class="col-md-3 col-sm-6 mb-2 pe-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center" style="background-color: #f3fbff;" >
                                        <span class="text-primary fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 mb-2 ps-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center"style="background-color: #f3fbff;">
                                        <span class="text-primary fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 mb-2 pe-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center"style="background-color: #f3fbff;">
                                        <span class="text-primary fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6 ps-sm-1">
                                    <div class="hour-input d-flex justify-content-center align-items-center"style="background-color: #f3fbff;">
                                        <span class="text-primary fw-5">8:10 - 20:00</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn btn-primary w-100">
                                Make an Appointment
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="our-services-section px-30">
                <div class="section-heading text-center mb-40">
                    <h2 class="text-primary fw-bold">Our Services</h2>
                </div>
                <div class="services">
                    <div class="row">
                        <div class="col-12 mb-40">
                            <div class="service-card d-flex flex-row">
                                <div class="card-img d-flex justify-content-center align-items-center me-sm-4 me-3">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="36" height="28"
                                        viewBox="0 0 36 28" fill="none">
                                        <g clip-path="url(#clip0_37_155)">
                                            <path
                                                d="M0 25.2152C0 19.6437 0 14.0722 0 8.50075C0.0704501 8.49791 0.139961 8.49225 0.210411 8.49225C12.0301 8.49225 23.8506 8.49225 35.6703 8.49225C35.7717 8.49225 35.8732 8.50452 35.9822 8.51208C35.9897 8.58007 35.9991 8.6254 35.9991 8.67072C35.9991 14.0628 36.0056 19.4558 35.985 24.8478C35.9831 25.2803 35.8647 25.7478 35.6769 26.1387C35.0513 27.4372 33.9767 28.0009 32.5508 27.999C22.8625 27.9896 13.1751 27.9943 3.48681 27.9943C3.35812 27.9943 3.22943 27.9934 3.10074 27.9887C1.75374 27.9386 0.590841 27.067 0.166262 25.7856C0.103327 25.5976 0.0544814 25.405 0 25.2152ZM9.16509 22.2557C8.06419 22.2557 7.01589 22.2557 5.95632 22.2557C5.95632 20.9289 5.95632 19.6277 5.95632 18.2905C6.51992 18.2905 7.05628 18.2981 7.59264 18.2877C8.0191 18.2792 8.32908 18.062 8.50568 17.6767C8.67663 17.3056 8.63624 16.9382 8.39577 16.6058C8.16188 16.2829 7.82654 16.1686 7.44423 16.1677C6.95389 16.1667 6.46356 16.1677 5.95726 16.1677C5.95726 15.1506 5.95726 14.1695 5.95726 13.1619C6.48798 13.1619 6.99053 13.1695 7.49307 13.16C8.15061 13.1468 8.60806 12.6973 8.60337 12.0854C8.59867 11.4735 8.14027 11.0438 7.47429 11.0391C6.70121 11.0334 5.92814 11.0372 5.15507 11.0381C4.18568 11.0381 3.82027 11.4064 3.81933 12.3847C3.81933 15.9363 3.81933 19.4888 3.81933 23.0404C3.81933 24.0329 4.18943 24.405 5.17949 24.4059C8.54231 24.4069 11.9042 24.4069 15.267 24.405C15.4192 24.405 15.5723 24.4031 15.7226 24.3804C16.2186 24.3049 16.5915 23.93 16.6027 23.4257C16.6243 22.4701 16.6243 21.5144 16.6027 20.5588C16.5905 20.0422 16.1979 19.6598 15.6906 19.5946C15.2163 19.5332 14.7325 19.8203 14.5841 20.2802C14.5268 20.4558 14.5146 20.6504 14.5108 20.8373C14.5014 21.3057 14.508 21.775 14.508 22.2585C13.4146 22.2585 12.3673 22.2585 11.2739 22.2585C11.2739 22.1112 11.2739 21.9856 11.2739 21.8591C11.272 21.4341 11.2842 21.0092 11.2645 20.5852C11.242 20.0875 10.9104 19.7108 10.4435 19.6107C9.77753 19.469 9.19515 19.9421 9.16978 20.6683C9.151 21.1848 9.16509 21.7033 9.16509 22.2557ZM25.1939 17.8438C23.4495 17.8438 21.7043 17.8429 19.9599 17.8438C19.1474 17.8448 18.7388 18.2414 18.736 19.0488C18.7303 20.4284 18.7313 21.8081 18.736 23.1887C18.7388 23.9744 19.1493 24.4012 19.9233 24.4021C23.4355 24.4069 26.9486 24.4078 30.4607 24.4021C31.2432 24.4012 31.6434 23.9791 31.6443 23.1906C31.6462 21.8109 31.6462 20.4313 31.6443 19.0507C31.6434 18.2461 31.2376 17.8448 30.4269 17.8438C28.6835 17.8429 26.9382 17.8438 25.1939 17.8438ZM25.1911 13.1619C26.9241 13.1619 28.6582 13.1638 30.3912 13.1591C30.565 13.1591 30.7454 13.1449 30.9107 13.0967C31.3653 12.9645 31.6603 12.5292 31.6434 12.0514C31.6274 11.5802 31.2902 11.159 30.8318 11.0646C30.673 11.0315 30.5058 11.0381 30.3424 11.0381C26.911 11.0372 23.4796 11.0372 20.0482 11.0372C19.9308 11.0372 19.8134 11.0344 19.6969 11.0438C19.1981 11.0853 18.8064 11.4735 18.7491 11.9777C18.6937 12.4612 18.9793 12.9381 19.4395 13.0854C19.6142 13.1411 19.8077 13.1572 19.9919 13.1581C21.7249 13.1638 23.458 13.1619 25.1911 13.1619ZM22.4802 16.4415C23.3462 16.4415 24.2113 16.4434 25.0774 16.4406C25.7735 16.4387 26.2328 16.0213 26.2394 15.3962C26.245 14.7691 25.7829 14.3206 25.1018 14.3187C23.3584 14.313 21.615 14.313 19.8716 14.3187C19.2141 14.3215 18.7472 14.7672 18.7397 15.3716C18.7322 15.9901 19.2056 16.4368 19.8829 16.4396C20.748 16.4444 21.6141 16.4415 22.4802 16.4415Z"
                                                fill="url(#paint0_linear_37_155)"></path>
                                            <path
                                                d="M-0.000157391 2.76407C0.057142 2.57521 0.109745 2.38445 0.17268 2.19748C0.622622 0.869768 1.82497 0.00760486 3.25933 0.00382758C5.96556 -0.00278265 8.67178 0.00193895 11.378 0.00193895C18.4305 0.00193895 25.4831 0.00193895 32.5356 0.00193895C34.6613 0.00193895 35.9989 1.35137 35.9998 3.49309C35.9998 4.43552 35.9998 5.37794 35.9998 6.36759C35.827 6.36759 35.6795 6.36759 35.5311 6.36759C23.8392 6.36759 12.1473 6.36759 0.45542 6.36759C0.303248 6.36759 0.151076 6.37326 -0.00109673 6.37609C-0.000157391 5.17208 -0.000157391 3.96808 -0.000157391 2.76407ZM4.02771 2.24847C4.02771 2.24942 4.02771 2.25036 4.02771 2.25036C3.73558 2.25036 3.4425 2.23431 3.15131 2.25414C2.62247 2.29002 2.21385 2.71969 2.1838 3.24378C2.15468 3.76222 2.51538 4.27876 3.04141 4.32314C3.69049 4.37791 4.35084 4.3798 4.99898 4.32503C5.54849 4.27876 5.89511 3.76883 5.85566 3.2164C5.81714 2.68664 5.41135 2.28058 4.87029 2.25036C4.58943 2.23525 4.30763 2.24847 4.02771 2.24847ZM8.74787 2.24942C8.45573 2.24942 8.16266 2.23525 7.87147 2.25225C7.33981 2.28436 6.92556 2.70552 6.89174 3.22773C6.85699 3.75372 7.20548 4.27404 7.73057 4.31936C8.38998 4.37697 9.06254 4.37697 9.72196 4.32031C10.2527 4.27498 10.589 3.7726 10.5598 3.23245C10.5317 2.70458 10.1259 2.2853 9.58857 2.25225C9.31053 2.23525 9.02873 2.24942 8.74787 2.24942ZM13.4107 4.36469C13.4107 4.36375 13.4107 4.36375 13.4107 4.3628C13.6916 4.3628 13.9734 4.38074 14.2524 4.35903C14.8686 4.31086 15.28 3.85854 15.2669 3.27023C15.2537 2.68569 14.8132 2.25886 14.1923 2.24658C13.6897 2.2362 13.1862 2.23714 12.6837 2.24658C12.0637 2.25792 11.6157 2.68192 11.5969 3.25984C11.5771 3.85759 12.0055 4.31842 12.6386 4.36091C12.896 4.37886 13.1543 4.36469 13.4107 4.36469Z"
                                                fill="url(#paint1_linear_37_155)"></path>
                                            <path
                                                d="M20.8636 22.251C20.8636 21.4794 20.8636 20.741 20.8636 19.9855C23.7492 19.9855 26.6142 19.9855 29.5073 19.9855C29.5073 20.7297 29.5073 21.4766 29.5073 22.251C26.6414 22.251 23.7689 22.251 20.8636 22.251Z"
                                                fill="url(#paint2_linear_37_155)"></path>
                                        </g>
                                        <defs>
                                            <linearGradient id="paint0_linear_37_155" x1="0" y1="8.49225"
                                                x2="18.5061" y2="38.712" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <linearGradient id="paint1_linear_37_155" x1="-0.00109673"
                                                y1="0.000305176" x2="2.61256" y2="13.0586"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <linearGradient id="paint2_linear_37_155" x1="20.8636" y1="19.9855"
                                                x2="22.1777" y2="24.422" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <clipPath id="clip0_37_155">
                                                <rect width="36" height="28" fill="white"></rect>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-primary">Web Design</h3>
                                    <p class="mb-0 text-gray-300">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="service-card d-flex flex-row">
                                <div class="card-img d-flex justify-content-center align-items-center me-sm-4 me-3">
                                    <svg width="28" height="28" viewBox="0 0 28 28" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_37_170)">
                                            <path
                                                d="M27.9975 19.9999C26.296 19.9999 24.6411 19.9915 22.9862 20.0024C21.5944 20.0116 20.4226 20.9347 20.0953 22.2735C20.027 22.5531 20.0045 22.8494 20.0028 23.1382C19.9937 24.7207 19.9979 26.304 19.997 27.8865C19.997 27.9065 19.9912 27.9274 19.9804 27.9967C19.8896 27.9967 19.7913 27.9967 19.6922 27.9967C18.1722 27.9967 16.6514 27.9984 15.1314 27.9958C13.295 27.9933 12.0024 26.7063 12.0015 24.8734C11.999 20.292 11.999 15.7098 12.0015 11.1284C12.0024 9.293 13.2933 8.00263 15.1264 8.00096C18.3754 7.99846 21.6244 7.99846 24.8734 8.00096C26.7091 8.00263 27.9958 9.28966 27.9975 11.1276C28.0008 13.9804 27.9983 16.8341 27.9983 19.6869C27.9975 19.7804 27.9975 19.8722 27.9975 19.9999ZM20.0287 12.0014C19.06 12.0014 18.0923 12.0006 17.1236 12.0014C16.4565 12.0023 16.0051 12.4029 16.0018 12.9938C15.9984 13.5839 16.4532 13.9996 17.112 14.0004C19.0384 14.0021 20.964 14.0021 22.8904 14.0004C23.5475 13.9996 24.0031 13.5814 23.9981 12.9913C23.9931 12.4146 23.5408 12.0031 22.9029 12.0014C21.9442 11.9998 20.9865 12.0014 20.0287 12.0014ZM18.9943 18.0001C19.6505 18.0001 20.306 18.0051 20.9623 17.9984C21.5511 17.9926 21.9917 17.5677 21.9984 17.0127C22.005 16.4451 21.5595 16.0044 20.9565 16.0019C19.6547 15.9969 18.3538 15.9977 17.052 16.0019C16.4424 16.0036 16.0001 16.4318 16.0009 17.0027C16.0018 17.5702 16.4482 17.9951 17.0578 17.9992C17.7033 18.0034 18.3488 18.0001 18.9943 18.0001Z"
                                                fill="url(#paint0_linear_37_170)"></path>
                                            <path
                                                d="M0.00333064 21.9763C0.00333064 20.686 0.00083205 19.3948 0.0041635 18.1044C0.00666209 16.8524 0.851185 16.0028 2.09715 16.0011C4.03272 15.9986 5.96913 15.9986 7.9047 16.0011C9.15149 16.0028 9.99851 16.8516 10.0002 18.1027C10.0027 20.7052 10.0035 23.3068 10.0002 25.9092C9.99851 27.1412 9.14816 27.995 7.92219 27.9975C5.97579 28.0017 4.02939 28.0017 2.08299 27.9975C0.856182 27.995 0.00666209 27.1412 0.00333064 25.9117C0.00083205 24.5997 0.00333064 23.2884 0.00333064 21.9763ZM4.00274 21.9839C4.00274 22.3277 3.99441 22.6708 4.0044 23.0147C4.02106 23.573 4.46664 24.0029 5.00967 23.9979C5.54103 23.9937 5.98495 23.573 5.99661 23.0288C6.01077 22.3419 6.0116 21.655 5.99661 20.9681C5.98495 20.4247 5.53937 20.0041 5.008 20.0007C4.46164 19.9974 4.02106 20.4231 4.0044 20.9848C3.99524 21.3178 4.00274 21.6508 4.00274 21.9839Z"
                                                fill="url(#paint1_linear_37_170)"></path>
                                            <path
                                                d="M21.1097 0.0033489C22.6922 0.0033489 24.2738 0.00251425 25.8562 0.0033489C27.1663 0.00418355 27.9958 0.837164 27.9983 2.15341C27.9992 2.76771 28.0042 3.38201 27.9967 3.99548C27.9825 5.12726 27.1238 5.99697 25.9936 5.99947C22.7355 6.00698 19.4782 6.00782 16.22 5.99279C15.9185 5.99112 15.6012 5.90098 15.3188 5.78413C14.6176 5.49534 13.9313 5.1715 13.2425 4.8535C12.4505 4.48792 12.0065 3.86861 12.0099 2.99223C12.0132 2.13004 12.4513 1.51657 13.2317 1.15683C13.9205 0.838833 14.6051 0.509981 15.3088 0.22787C15.6287 0.0993336 15.9893 0.0175379 16.3333 0.01253C17.9249 -0.00917084 19.5173 0.0033489 21.1097 0.0033489Z"
                                                fill="url(#paint2_linear_37_170)"></path>
                                            <path
                                                d="M8.86245 13.8509C8.54679 13.9069 8.28777 13.992 8.02708 13.9937C6.00656 14.0045 3.98604 14.0095 1.96634 13.9962C0.887786 13.9887 0.0116145 13.1206 0.00828304 12.0439C-0.00254418 8.68028 -0.00337704 5.31665 0.00828304 1.95301C0.0124473 0.892169 0.882789 0.0174567 1.94219 0.00911017C3.98354 -0.00674817 6.02488 -7.09744e-05 8.0654 0.0116141C8.31442 0.0132834 8.56261 0.101756 8.86911 0.161851C8.43602 0.640105 8.05957 1.0566 7.68145 1.47142C6.64537 2.61238 5.60595 3.75084 4.57154 4.89264C3.40969 6.17466 3.41303 7.84063 4.5757 9.1168C5.92161 10.5958 7.26585 12.0756 8.61092 13.5555C8.67838 13.6306 8.74251 13.7099 8.86245 13.8509Z"
                                                fill="url(#paint3_linear_37_170)"></path>
                                            <path
                                                d="M9.9727 12.079C8.73673 10.7211 7.55906 9.38645 6.33558 8.09525C5.49689 7.20969 5.52854 6.76398 6.33558 5.91014C7.55739 4.61726 8.7359 3.28433 9.9727 1.92468C9.9727 5.32421 9.9727 8.67116 9.9727 12.079Z"
                                                fill="url(#paint4_linear_37_170)"></path>
                                            <path
                                                d="M27.3079 21.9997C25.5306 23.7725 23.7724 25.5244 22.0184 27.2738C22.0151 27.243 22.0001 27.1678 22.0001 27.0927C21.9984 25.7606 21.9976 24.4277 22.0001 23.0956C22.0017 22.4095 22.4032 22.0022 23.0819 22.0005C24.4861 21.9972 25.8912 21.9997 27.3079 21.9997Z"
                                                fill="url(#paint5_linear_37_170)"></path>
                                        </g>
                                        <defs>
                                            <linearGradient id="paint0_linear_37_170" x1="11.9997" y1="7.99908"
                                                x2="32.0887" y2="22.2203" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <linearGradient id="paint1_linear_37_170" x1="0.00222015" y1="15.9992"
                                                x2="12.2132" y2="25.0021" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <linearGradient id="paint2_linear_37_170" x1="12.0099"
                                                y1="-0.000244141" x2="16.6101" y2="10.839"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <linearGradient id="paint3_linear_37_170" x1="-0.000152588"
                                                y1="-0.000244141" x2="12.7219" y2="7.12889"
                                                gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <linearGradient id="paint4_linear_37_170" x1="5.71838" y1="1.92468"
                                                x2="12.7682" y2="4.53814" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <linearGradient id="paint5_linear_37_170" x1="21.9985" y1="21.9988"
                                                x2="27.5793" y2="26.969" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#F6A932"></stop>
                                                <stop offset="1" stop-color="#FF5A0E"></stop>
                                            </linearGradient>
                                            <clipPath id="clip0_37_170">
                                                <rect width="28" height="28" fill="white"></rect>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="card-body p-0">
                                    <h3 class="card-title fs-18 text-primary">
                                        Branding Design
                                    </h3>
                                    <p class="mb-0 text-gray-300">
                                        Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                        sed do eiusmod tempor incididunt ut labore et dolore.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="gallery-section pt-60 px-sm-0">
                <div class="phyton-img">
                    <img src="{{ asset('assets/img/vcard17/phyton.png') }}" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="text-primary fw-bold">Gallery</h2>
                </div>
                <div class="">
                    <div class="gallery-slider">
                        <div class="slide">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard17/gallery-img1.png') }}" loading="lazy"/>
                            </div>
                        </div>
                        <div class="slide">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard17/gallery-img2.png') }}" loading="lazy"/>
                            </div>
                        </div>
                        <div class="slide">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard17/gallery-img3.png') }}" loading="lazy"/>
                            </div>
                        </div>
                        <div class="slide">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard17/gallery-img1.png') }}" loading="lazy"/>
                            </div>
                        </div>
                        <div class="slide">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard17/gallery-img2.png') }}" loading="lazy"/>
                            </div>
                        </div>
                        <div class="slide">
                            <div class="gallery-img">
                                <img src="{{ asset('assets/img/vcard17/gallery-img3.png') }}" loading="lazy"/>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="product-section pt-60">
                <div class="java-img">
                    <img src="{{ asset('assets/img/vcard17/java.png') }}" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="text-primary fw-bold">Products</h2>
                </div>
                <div class="product-slider pt-2">
                    <div>
                        <div class="card product-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard17/product-img1.png') }}"
                                    class="w-100 object-fit-cover" loading="lazy"/>
                            </div>
                            <div class="bg-primary-light card-body">
                                <div class="d-flex justify-content-between">
                                    <div class="product-title">
                                        <h3 class="text-primary fs-18 fw-5">Laptop</h3>
                                    </div>
                                    <div class="fs-18 fw-6 text-primary">$200</div>
                                </div>
                                <p class="text-gray-300 mb-0">
                                    Lorem ipsum dolor sit amet, consectetur adipis cing elit.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="card product-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard17/product-img2.png') }}"
                                    class="w-100 object-fit-cover" loading="lazy"/>
                            </div>
                            <div class="bg-primary-light card-body">
                                <div class="d-flex justify-content-between">
                                    <div class="product-title">
                                        <h3 class="text-primary fs-18 fw-5">Laptop</h3>
                                    </div>
                                    <div class="fs-18 fw-6 text-primary">$200</div>
                                </div>
                                <p class="text-gray-300 mb-0">
                                    Lorem ipsum dolor sit amet, consectetur adipis cing elit.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="card product-card">
                            <div class="card-img">
                                <img src="{{ asset('assets/img/vcard17/product-img3.png') }}"
                                    class="w-100 object-fit-cover" loading="lazy"/>
                            </div>
                            <div class="bg-primary-light card-body">
                                <div class="d-flex justify-content-between">
                                    <div class="product-title">
                                        <h3 class="text-primary fs-18 fw-5">Laptop</h3>
                                    </div>
                                    <div class="fs-18 fw-6 text-primary">$200</div>
                                </div>
                                <p class="text-gray-300 mb-0">
                                    Lorem ipsum dolor sit amet, consectetur adipis cing elit.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-section pt-30 pb-50">
                <div class="c-language-img">
                    <img src="{{ asset('assets/img/vcard17/c++.png') }}" loading="lazy"/>
                </div>
                <div class="section-heading text-center mb-40">
                    <h2 class="text-primary fw-bold">Blog</h2>
                </div>
                <div class="blog-slider pt-3 mt-3">
                    <div class="">
                        <div class="blog-card blog-1 card">
                            <div class="overlay">
                                <img src="{{ asset('assets/img/vcard17/blog-img.png') }}" alt="profile"
                                    class="h-100 w-100 " loading="lazy"/>
                            </div>
                            <div class="card-body d-flex flex-column justify-content-end">
                                <h6 class="card-title text-blue fw-5 fs-20">Coding</h6>
                                <p class="mb-0 fw-5 fs-14 text-white">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="blog-card blog-1 card">
                            <div class="overlay">
                                <img src="{{ asset('assets/img/vcard17/blog-img.png') }}" alt="profile"
                                    class="h-100 w-100 " loading="lazy"/>
                            </div>
                            <div class="card-body d-flex flex-column justify-content-end">
                                <h6 class="card-title text-blue fw-5 fs-20">Coding</h6>
                                <p class="mb-0 fw-5 fs-14 text-white">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry. Lorem Ipsum has been the industry's
                                    standard dummy text.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial-section">
                <div class="section-heading text-center mb-40">
                    <h2 class="text-primary fw-bold">Testimonial</h2>
                </div>
                <div class="bg">
                    <div class="testimonial-bg">
                        <img src="{{ asset('assets/img/vcard17/testimonial-bg.png') }}"
                            class="w-100 h-100 object-fit-cover" loading="lazy"/>
                    </div>
                    <div class="testimonial-slider mb-0">
                        <div class="d-flex align-items-end">
                            <div class="card">
                                <div class="card-img">
                                    <img src="{{ asset('assets/img/vcard17/testimonial-profile.png') }}"
                                        class="w-100 h-100 object-fit-cover" loading="lazy"/>
                                </div>
                                <div class="card-body text-center">
                                    <h4 class="text-primary fs-6 fw-7">Jane Doe</h4>
                                    <p class="text-gray-300 fs-14 mb-0">
                                        Lorem Ipsum is simply dummy text of the printing and
                                        typesetting industry. Lorem Ipsum has been the industry's
                                        standard dummy text.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-end">
                            <div class="card">
                                <div class="card-img">
                                    <img src="{{ asset('assets/img/vcard17/testimonial-profile.png') }}"
                                        class="w-100 h-100 object-fit-cover" loading="lazy"/>
                                </div>
                                <div class="card-body text-center">
                                    <h4 class="text-primary fs-6 fw-7">Jane Doe</h4>
                                    <p class="text-gray-300 fs-14 mb-0">
                                        Lorem Ipsum is simply dummy text of the printing and
                                        typesetting industry. Lorem Ipsum has been the industry's
                                        standard dummy text.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex align-items-end">
                            <div class="card">
                                <div class="card-img">
                                    <img src="{{ asset('assets/img/vcard17/testimonial-profile.png') }}"
                                        class="w-100 h-100 object-fit-cover" loading="lazy"/>
                                </div>
                                <div class="card-body text-center">
                                    <h4 class="text-primary fs-6 fw-7">Jane Doe</h4>
                                    <p class="text-gray-300 fs-14 mb-0">
                                        Lorem Ipsum is simply dummy text of the printing and
                                        typesetting industry. Lorem Ipsum has been the industry's
                                        standard dummy text.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="qr-code-section pt-60 pb-40">
                    <div class="qr-bg-img">
                        <img src="{{ asset('assets/img/vcard17/qr-bg-img.png') }}" loading="lazy"/>
                    </div>
                    <div class="code-img">
                        <img src="{{ asset('assets/img/vcard17/code.png') }}" loading="lazy"/>
                    </div>
                    <div class="section-heading text-center pb-40 mb-40">
                        <h2 class="text-primary fw-bold">QR Code</h2>
                    </div>
                    <div class="px-30">
                        <div class="qr-code mt-3 mx-auto position-relative">
                            <div class="qr-profile-img">
                                <img src="{{ asset('assets/img/vcard17/qr-profile-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" loading="lazy"/>
                            </div>
                            <div class="qr-code-img mx-auto">
                                <img src="{{ asset('assets/img/vcard17/qr-code.png') }}"
                                    class="w-100 h-100 object-fit-cover" loading="lazy"/>
                            </div>
                            <div class="text-center">
                                <button class="btn btn-primary w-100" type="button">
                                    Download My QR Code
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="business-hour-section pb-40 px-30">
                    <div class="section-heading text-center mb-40">
                        <h2 class="text-primary fw-bold">Business Hours</h2>
                    </div>
                    <div class="">
                        <div class="business-hour-card mt-40">
                            <div class="row">
                                <div class="col-12 d-flex justify-content-between mb-2">
                                    <span class="me-2">Sunday:</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                                <div class="col-12 d-flex justify-content-between mb-2">
                                    <span class="me-2">Monday:</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                                <div class="col-12 d-flex justify-content-between mb-2">
                                    <span class="me-2">Tuesday:</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                                <div class="col-12 d-flex justify-content-between mb-2">
                                    <span class="me-2">Wednesday:</span>
                                    <span>08:10 - 10:00</span>
                                </div>
                                <div class="col-12 d-flex justify-content-between mb-2">
                                    <span class="me-2">Thursday:</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                                <div class="col-12 d-flex justify-content-between mb-2">
                                    <span class="me-2">Friday:</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                                <div class="col-12 d-flex justify-content-between mb-2">
                                    <span class="me-2">Saturday:</span>
                                    <span>Closed</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="contact-us-section px-30">
                    <div class="section-heading text-center mb-40">
                        <h2 class="text-primary fw-bold">Inquiries</h2>
                    </div>
                    <div class="contact-form">
                        <div class="contact-icon">
                            <img src="{{ asset('assets/img/vcard17/contact-icon.png') }}" loading="lazy"/>
                        </div>
                        <form action="">
                            <div class="row">
                                <div class="col-12">
                                    <input type="text" class="form-control" placeholder="Your Name" />
                                </div>
                                <div class="col-12">
                                    <input type="tel" class="form-control" placeholder="Enter Phone Number" />
                                </div>
                                <div class="col-12">
                                    <input type="email" class="form-control" placeholder="Email Address" />
                                </div>
                                <div class="col-12">
                                    <textarea class="form-control h-100" placeholder="Type a Message here..." rows="3"></textarea>
                                </div>
                                <div class="col-12 text-center mt-4">
                                    <button class="btn btn-primary" type="submit">
                                        Send Message
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="create-vcard-section pt-40">
                    <div class="section-heading text-center mb-40">
                        <h2 class="text-primary fw-bold">Create Your VCard</h2>
                    </div>
                    <div class="px-30 pt-30 pb-30 bg-primary-light">
                        <div class="vcard-link-card card">
                            <div class="d-flex align-items-center justify-content-center">
                                <a href="https://vcards.infyom.com/marlonbrasil"
                                    class="text-primary link-text fw-5">https://vcards.infyom.com/marlonbrasil</a>
                                <i class="icon fa-solid fa-arrow-up-right-from-square ms-3"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="add-to-conact-section pb-4 px-30 bg-primary-light">
                    <div class="text-center">
                        <button class="btn btn-primary">Add to Contact</button>
                    </div>
                </div>
                <div class="btn-section cursor-pointer">
                    <div class="fixed-btn-section">
                        {{-- <div class="bars-btn developer-bars-btn">
              <svg
                width="25"
                height="25"
                viewBox="0 0 25 25"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M15.4134 0.540771H22.489C23.572 0.540771 24.4601 1.42891 24.4601 2.51188V9.5875C24.4601 10.6776 23.5731 11.5586 22.489 11.5586H15.4134C14.3222 11.5586 13.4423 10.6787 13.4423 9.5875V2.51188C13.4423 1.42783 14.3233 0.540771 15.4134 0.540771Z"
                  stroke="white"
                />
                <path
                  d="M2.97143 0.5H8.74589C10.1129 0.5 11.2173 1.6122 11.2173 2.97143V8.74589C11.2173 10.1139 10.1139 11.2173 8.74589 11.2173H2.97143C1.6122 11.2173 0.5 10.1129 0.5 8.74589V2.97143C0.5 1.61328 1.61328 0.5 2.97143 0.5Z"
                  stroke="white"
                />
                <path
                  d="M2.97143 13.783H8.74589C10.1139 13.783 11.2173 14.8863 11.2173 16.2544V22.0289C11.2173 23.3881 10.1129 24.5003 8.74589 24.5003H2.97143C1.61328 24.5003 0.5 23.387 0.5 22.0289V16.2544C0.5 14.8874 1.6122 13.783 2.97143 13.783Z"
                  stroke="white"
                />
                <path
                  d="M16.2537 13.783H22.0282C23.3874 13.783 24.4996 14.8874 24.4996 16.2544V22.0289C24.4996 23.387 23.3863 24.5003 22.0282 24.5003H16.2537C14.8867 24.5003 13.7823 23.3881 13.7823 22.0289V16.2544C13.7823 14.8863 14.8856 13.783 16.2537 13.783Z"
                  stroke="white"
                />
              </svg>
            </div>
            <div class="sub-btn">
              <div class="social-btn developer-sub-btn wp-btn">
                <i class="fa-brands fa-whatsapp text-primary"></i>
              </div>
              <div class="social-btn developer-sub-btn wp-btn mt-3">
                <i class="fa-solid fa-share-nodes text-primary"></i>
              </div>
            </div>
          </div> --}}
                    </div>
                </div>
            </div>
</body>
<script type="text/javascript" src="{{ asset('assets/js/front-third-party.js') }}"></script>
<script type="text/javascript" src="{{ asset('front/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('assets/js/slider/js/slick.min.js') }}" type="text/javascript"></script>
<script src="../js/jquery.min.js"></script>
<script src="../js/bootstrap.bundle.min.js"></script>
<script src="../js/slick.min.js"></script>
<script src="../js/custom.js"></script>

<script>
    $().ready(function() {
        var gallery = $(".gallery-slider");
        gallery
            .on("init", function(event, slick, currentSlide) {
                var cur = $(slick.$slides[slick.currentSlide]),
                    next = cur.next(),
                    prev = cur.prev();
                prev.addClass("slick-sprev");
                next.addClass("slick-snext");
                cur.removeClass("slick-snext").removeClass("slick-sprev");
                slick.$prev = prev;
                slick.$next = next;
            })
            .on("beforeChange", function(event, slick, currentSlide, nextSlide) {
                var cur = $(slick.$slides[nextSlide]);
                slick.$prev.removeClass("slick-sprev");
                slick.$next.removeClass("slick-snext");
                (next = cur.next()), (prev = cur.prev());
                prev.prev();
                prev.next();
                prev.addClass("slick-sprev");
                next.addClass("slick-snext");
                slick.$prev = prev;
                slick.$next = next;
                cur.removeClass("slick-next").removeClass("slick-sprev");
            });

        $(".gallery-slider").slick({
            speed: 1000,
            arrows: false,
            dots: false,
            infinite: true,
            centerMode: true,
            slidesPerRow: 1,
            slidesToShow: 1,
            slidesToScroll: 1,
            centerPadding: "0",
        });
        $(".product-slider").slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            centerMode: true,
            arrows: false,
            dots: true,
            speed: 300,
            centerPadding: "115px",
            infinite: true,
            autoplaySpeed: 5000,
            autoplay: true,
            responsive: [{
                    breakpoint: 575,
                    settings: {
                        centerPadding: "115px",
                        dots: true,
                    },
                },
                {
                    breakpoint: 480,
                    settings: {
                        centerPadding: "0",
                        dots: true,
                    },
                },
            ],
        });
        $(".blog-slider").slick({
            arrows: true,
            infinite: true,
            dots: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: true,
            prevArrow: '<button class="slide-arrow prev-arrow"><i class="fa-solid fa-chevron-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow"><i class="fa-solid fa-chevron-right"></i></button>',
            responsive: [{
                breakpoint: 575,
                settings: {
                    dots: true,
                    arrows: false,
                },
            }, ],
        });
    });
</script>
<script>
    var rev = $(".testimonial-slider");
    rev
        .on("init", function(event, slick, currentSlide) {
            var cur = $(slick.$slides[slick.currentSlide]),
                next = cur.next(),
                prev = cur.prev();
            prev.addClass("slick-sprev");
            next.addClass("slick-snext");
            cur.removeClass("slick-snext").removeClass("slick-sprev");
            slick.$prev = prev;
            slick.$next = next;
        })
        .on("beforeChange", function(event, slick, currentSlide, nextSlide) {
            var cur = $(slick.$slides[nextSlide]);
            slick.$prev.removeClass("slick-sprev");
            slick.$next.removeClass("slick-snext");
            (next = cur.next()), (prev = cur.prev());
            prev.prev();
            prev.next();
            prev.addClass("slick-sprev");
            next.addClass("slick-snext");
            slick.$prev = prev;
            slick.$next = next;
            cur.removeClass("slick-next").removeClass("slick-sprev");
        });

    $(".testimonial-slider").slick({
        speed: 1000,
        arrows: false,
        dots: true,
        infinite: true,
        centerMode: true,
        slidesPerRow: 1,
        slidesToShow: 1,
        slidesToScroll: 1,
        centerPadding: "0",
    });
</script>
<script>
    $("#myID").flatpickr();
</script>

<script>
    $(document).ready(function() {
        $('.dropdown1').hover(function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(100);
        }, function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(100);
        });
    });
</script>

</html>
